/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.widget.rialto.figure.TabFigure;
import jp.sf.maskat.widget.rialto.figure.TabFolderFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;



public class TabFolderEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	protected IFigure createFigure() {
		return new TabFolderFigure();
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}

	protected void setActivePage(TabEditPart editPart) {
		TabFolderFigure figure = (TabFolderFigure) getFigure();
		figure.setAllTabPageInvisible();
		
		editPart.getFigure().setForegroundColor(
				Display.getCurrent().getSystemColor(SWT.COLOR_BLACK));
		
		TabItemEditPart item = getTabItemEditPart(editPart.getModel());
		if (item != null) {
			item.getFigure().setVisible(true);
		}
	}

	protected void fireActivated() {
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			if (children.size() > 0 && children.get(i) instanceof TabEditPart) {
				setActivePage((TabEditPart) children.get(i));
				return;
			}
		}
	}
	
	public void refreshSelectedWidget(ComponentEditPart child) {
		if (child instanceof TabEditPart) {
			setActivePage((TabEditPart) child);
		} else if (child instanceof TabItemEditPart) {
			setActivePage(getTabEditPart(child.getModel()));
		}
		if (getParent() instanceof ComponentEditPart) {
			((ComponentEditPart) getParent()).refreshSelectedWidget(this);
		}
		refreshVisuals();
	}

	protected void refreshChildren() {
		HashMap modelToEditPart = new HashMap();
		HashMap tabEditPart = new HashMap();
		List children = getChildren();

		for (int i = 0; i < children.size(); i++) {
			EditPart editPart = (EditPart)children.get(i);
			if (!(editPart instanceof TabEditPart)) {
				modelToEditPart.put(editPart.getModel(), editPart);
			} else {
				tabEditPart.put(editPart.getModel(), editPart);
			}
		}
		List modelObjects = getModelChildren();
		int index = 0;
		int tabPosition = 0;
		for (int i = 0; i < modelObjects.size(); i++) {
			Object model = modelObjects.get(i);
			EditPart editPart = (EditPart) modelToEditPart.get(model);
			if (editPart != null) {
				reorderChild (editPart, index++);
				TabEditPart tabPart = (TabEditPart) tabEditPart.get(model);
				if (tabPart != null) {
					tabPart.setIndex(tabPosition++);
					reorderChild(tabPart, index++);
					tabPart.refreshVisuals();
				}
			} else {
				editPart = createChild(model);
				addChild(editPart, index++);
				if (editPart instanceof TabItemEditPart) {
					TabEditPart part = new TabEditPart(tabPosition++);
					part.setModel(model);
					addChild(part, index++); 
				}
			}
		}
		ArrayList list = new ArrayList();
		for (int i = index; i < children.size(); i++) {
			list.add(children.get(i));
		}
		for (int i = 0; i < list.size(); i++) {
			removeChild((EditPart) list.get(i));
		}
	}
	
	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), 
				comp.getWidth(), comp.getHeight());

		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		String name = evt.getPropertyName();
		if ("addChild".equals(name) || "removeChild".equals(name)) {
			refreshChildren();
		} else 	if ("widthTabName".equals(name)) {
			List list = getChildren();
			for (int i = 0; i < list.size(); i++) {
				Object obj = list.get(i);
				if (obj instanceof TabEditPart) {
					((TabEditPart) obj).refreshVisuals();
				}
			}
		} else if ("constraint".equals(name) ||
					"width".equals(name) || "height".equals(name)) {
			Component model = ((Component) getModel());
			Rectangle constraint = new Rectangle(0, TabFigure.HEIGHT + 1, model.getWidth() - 2,
					model.getHeight() - TabFigure.HEIGHT - 1);
			List children = getChildren();
			for (int i = 0; i < children.size(); i++) {
				Object child = children.get(i);			
				if (child instanceof TabItemEditPart) {
					TabItemEditPart editPart = (TabItemEditPart) child;
					getFigure().setConstraint(editPart.getFigure(), constraint);
				}
			}
		}
		super.propertyChange(evt);
	}
	
	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"tabItem".equals(child.getName())) {
				return true;
			}
		}
		return false;
	}
	
	public int getWidthTabName() {
		return ((Integer) ((DynaComponent) getModel()).
				get("widthTabName")).intValue();
	}

	public void setWidthTabName(int width) {
		((DynaComponent) getModel()).set("widthTabName", new Integer(width));
	}

	private TabItemEditPart getTabItemEditPart(Object model) {
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			EditPart editPart = (EditPart) children.get(i);
			if (editPart instanceof TabItemEditPart) {
				if (editPart.getModel() == model) {
					return (TabItemEditPart) editPart;
				}
			}
		}
		return null;
	}
	
	private TabEditPart getTabEditPart(Object model) {
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			EditPart editPart = (EditPart) children.get(i);
			if (editPart instanceof TabEditPart) {
				if (editPart.getModel() == model) {
					return (TabEditPart) editPart;
				}
			}
		}
		return null;
	}
}
