/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.widget.rialto.figure.GridFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;


public class GridEditPart extends ComponentEditPart implements VerticalResizable {
	
	protected IFigure createFigure() {
		return new GridFigure(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("text".equals(evt.getPropertyName())) {
			getFigure().repaint();
		} else 	if ("gridHeaderTitle".equals(evt.getPropertyName())
						|| "gridHeaderWidth".equals(evt.getPropertyName())
						|| "lineHeight".equals(evt.getPropertyName())) {
			for (Iterator it = this.getChildren().iterator(); it != null
				&& it.hasNext();) {
				((AbstractGraphicalEditPart) it.next()).refresh();
			}
			getFigure().repaint();
		} else 	if ("addChild".equals(evt.getPropertyName())
					|| "removeChild".equals(evt.getPropertyName())) {
			refresh();
			for (Iterator it = this.getChildren().iterator(); it != null
					&& it.hasNext();) {
				((AbstractGraphicalEditPart) it.next()).refresh();
			}
			this.getFigure().repaint();
		}
		super.propertyChange(evt);
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		if (result != null) {
			return result;
		}
		return super.getModelChildren();
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		int width = headerTotalWidth();
		if (width == 0) {
			width = GridFigure.DEFAULT_WIDTH; 
		}
		Rectangle constraint = new Rectangle(comp.getLeft(),
				comp.getTop(), width, comp.getHeight());
		
		((GraphicalEditPart) getParent()).setLayoutConstraint(
				this, getFigure(), constraint);
	}

	public void refreshGridWidget() {
		List headers = getHeadersIt();
		for (int i = 0; i < headers.size(); i++) {
			((GridHeaderEditPart) headers.get(i)).refreshVisuals();
		}
		refreshVisuals();
	}
	
	public List getHeadersIt() {
		ArrayList result = new ArrayList();
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			Object obj = children.get(i);
			if (obj instanceof GridHeaderEditPart) {
				result.add(obj);
			}
		}
		return result;
	}

	public int headerTotalWidth() {
		int result = 0;
		List headers = ((Component) getModel()).getChildren();
		for (int i = 0; i < headers.size(); i++) {
			Object child = headers.get(i);
			if (child instanceof DynaComponent) {
				DynaComponent header = (DynaComponent) child;
				if ("gridHeader".equals(header.getDynaClass().getName())) {
					result += header.getWidth();
				}
			}
		}
		return result;
	}

	public int indexOfHeader(GridHeaderEditPart headerDef) {
		List headers = this.getHeadersIt();
		for (int i = 0; i < headers.size(); i++) {
			Object obj = headers.get(i);
			if (obj instanceof GridHeaderEditPart) {
				if (obj == headerDef) {
					return i;
				}
			}
		}
		return -1;
	}
	
	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"gridHeader".equals(child.getName())) {
				return true;
			} else 	if (dynaClass.getLibrary() == child.getLibrary() &&
				"gridLine".equals(child.getName())) {
				return true;
			}
		}
		return false;
	}
	
	public int getLineHeight() {
		return ((Integer) ((DynaComponent) getModel()).
				get("lineHeight")).intValue();
	}
}
