/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.widget.rialto.figure.FrameFigure;

import org.eclipse.draw2d.IFigure;



public class FrameEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {
	
	protected IFigure createFigure() {
		return new FrameFigure();
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName()) ||
			"removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
}
