/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.widget.rialto.figure.DivSplitFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;


public class DivSplitEditPart extends ComponentEditPart {
	private int index = 0;
	
	protected IFigure createFigure() {
		return new DivSplitFigure();
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}

	protected void refreshVisuals() {
		SplitterEditPart parent = (SplitterEditPart) getParent();
		
		Component parentComp = (Component) parent.getModel();
		double prop = index == 0 ? parent.getProp() : 1.0 - parent.getProp();
		Rectangle constraint = null;
		
		/* HORIZONTAL */
		if ("h".equals(parent.getOrientation())) {
			int size = (int) ((double) parentComp.getWidth() * prop) - 2;
			int left = (index == 0) ? 0 : parentComp.getWidth() - size - 1;
			int top = 0;
			int width = size;
			int height = parentComp.getHeight() - 2;
			constraint = new Rectangle(left + 1, top + 1, width - 2, height - 2);
		/* VERTICAL */
		} else {
			int size = (int) ((double) parentComp.getHeight() * prop) - 2;
			int left = 0;
			int top = (index == 0) ? 0 : parentComp.getHeight() - size - 1;
			int width = parentComp.getWidth() - 2;
			int height = size;
			constraint = new Rectangle(left + 1, top + 1, width - 2, height - 2);
		}
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}
	
	public void refreshSelectedWidget(ComponentEditPart child) {
		if (getParent() instanceof ComponentEditPart) {
			((ComponentEditPart) getParent()).refreshSelectedWidget(this);
		}
		refreshVisuals();
	}	
	
	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();
			
			return !child.isItem();
		}
		return true;
	}
	
	public boolean canCopy() {
		return false;
	}

	public boolean canDelete() {
		return false;
	}
}
