/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.widget.rialto.figure.CodeLibFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;


public class CodeLibEditPart extends ComponentEditPart
	implements  HorizontalResizable {
	
	protected IFigure createFigure() {
		return new CodeLibFigure(getBoolWithLabel());
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				comp.getWidth(), d.height + 10);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("boolWithLabel".equals(evt.getPropertyName())) {
			((CodeLibFigure) getFigure()).setWithLabelInput(
					getBoolWithLabel());

			getFigure().repaint();
		}
		super.propertyChange(evt);
	}
	
	public boolean getBoolWithLabel() {
		return ((Boolean) ((DynaComponent) getModel()).
			get("boolWithLabel")).booleanValue();
	}

	public void setBoolWithLabel(boolean widthLabel) {
		((DynaComponent) getModel()).
			set("boolWithLabel", new Boolean(widthLabel));
	}
}
