/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.commands;

import jp.sf.maskat.core.layout.Component;

import org.eclipse.gef.commands.Command;


public class DelGridHeaderCommand extends Command {

	private Component grid;

	private Component header;

	private int idx;

	public DelGridHeaderCommand(Component grid, Component header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		idx = grid.getChildIdx(header);
		if (idx == -1) {
			throw new IllegalStateException(
					"The component is not a child of the container.");
		}
		grid.removeChild(header);
	}

	public void undo() {
		grid.addChildToIdx(header, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
