/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.commands;

import jp.sf.maskat.core.layout.Component;

import org.eclipse.gef.commands.Command;


public class AddGridHeaderCommand extends Command {
	
	Component grid;

	Component header;

	public AddGridHeaderCommand(Component grid, Component header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		grid.addChild(header);
	}

	public void undo() {
		grid.removeChild(header);
	}

	public boolean canUndo() {
		return true;
	}
}
