/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.nature;

import java.net.URI;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.project.NewMaskatProjectCreationPage;
import jp.sf.maskat.ui.wizards.project.PluginResourceData;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

/**
 * Standard main page for a wizard that is creates a project resource.
 * <p>
 * This page may be used by clients as-is; it may be also be subclassed to suit.
 * </p>
 * <p>
 * Example usage:
 * <pre>
 * mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
 * mainPage.setTitle("Project");
 * mainPage.setDescription("Create a new project resource.");
 * </pre>
 * </p>
 */
public class AddMaskatNatureCreationPage extends NewMaskatProjectCreationPage {
	
	/** The wizard page ID */
	public static final String PAGE_ID = MaskatUIPlugin.PLUGIN_ID
			+ ".addMaskatNatureCreationPage";
	
	public AddMaskatNatureCreationPage(IProject project, IPath path, boolean copy) {
		this(project, PAGE_ID, path, copy);
		setTitle(Messages.getString("wizard.nature.title")); //$NON-NLS-1$
		setDescription(Messages.getString("wizard.nature.description")); //$NON-NLS-1$
	}
	
    /**
     * Creates a new project creation wizard page.
     *
     * @param pageName the name of this page
     */
    public AddMaskatNatureCreationPage(IProject project, String pageName,
    		IPath path, boolean copy) {
    	super(path, copy);
    	setInitialProjectName(project.getName());
        setPageComplete(false);
    }

    /** (non-Javadoc)
     * Method declared on IDialogPage.
     */
    public void createControl(Composite parent) {
    	super.createControl(parent);
    	Composite composite = locationArea.getBrowseButton().getParent();
    	Control[] controls = composite.getChildren();
    	for (int i = 0; i < controls.length; i++) {
    		controls[i].setEnabled(false);
    	}
    	projectLabel.setEnabled(false);
    	projectNameField.setEnabled(false);
    }
	  
    /**
     * Returns whether this page's controls currently all contain valid 
     * values.
     *
     * @return <code>true</code> if all controls are valid, and
     *   <code>false</code> if at least one is invalid
     */
    protected boolean validatePage() {
    	if (maskatFWPath == null) { 
    		return false;
    	}
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String path = maskatFWPath.getText();
		if (path == null || path.length() == 0) {
			setErrorMessage(Messages.getString(
					"wizard.project.msg.error.notfwpath")); //$NON-NLS-1$);
			maskatFWPath.setFocus();
			return false;
		}
		URI fwUrl = FileSystemSupportRegistry.getInstance()
			.getDefaultConfiguration().getContributor().getURI(path);

        IProject handle = getProjectHandle();
        IStatus fwLocationStatus = workspace.validateProjectLocationURI(handle, fwUrl);
        if (!fwLocationStatus.isOK()) {
            setErrorMessage(fwLocationStatus.getMessage());
			maskatFWPath.setFocus();
            return false;
        }
        setErrorMessage(null);
        setMessage(null);
        return true;
    }
    
	public PluginResourceData[] getSelectedPlugins() {
		Object[] select = viewer.getCheckedElements();
		PluginResourceData[] result = new PluginResourceData[select.length];
		for (int i = 0; i < select.length; i++) {
			result[i] = (PluginResourceData) select[i];
		}
		return result;
	}
}

