/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.export;

import jp.sf.maskat.ui.ISharedImages;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class ExportMessageSchemaWizardPage extends WizardPage {

	private ExportMessageSchemaDialogArea dialogArea;

	private IResource selectElement;
	
	public ExportMessageSchemaWizardPage(IResource selectElement) {
		super("exportSchemaWizard"); //$NON-NLS-1$
		setTitle(Messages.getString("exportSchemaWizard.title")); //$NON-NLS-1$
		setDescription(Messages.getString("exportSchemaWizard.description")); //$NON-NLS-1$
		ImageDescriptor image = MaskatUIPlugin.getImageDescriptor(
				ISharedImages.IMG_WIZBAN_NEWFILE);
		setImageDescriptor(image);
		this.selectElement = selectElement;
	}
	
	public void createControl(Composite parent) {
		dialogArea = new ExportMessageSchemaDialogArea(parent, SWT.NONE, selectElement) {
			public void setValid(boolean valid) {
				ExportMessageSchemaWizardPage.this.setPageComplete(valid);
			}
			public void setErrorMessage(String newMessage) {
				ExportMessageSchemaWizardPage.this.setErrorMessage(newMessage);
			}
		};		
		setControl(dialogArea);
		dialogArea.initialize();
	}
	
	public IPath getEventFilePath() {
		return new Path(dialogArea.getEventFilePath());
	}
	
	public void setEventFilePath(IPath path) {
		dialogArea.setEventFilePath(path.toString());
	}

	public IPath getOutputFilePath() {
		return new Path(dialogArea.getOutputFilePath());
	}
	
	public void setOutputFilePath(IPath path) {
		dialogArea.setOutputFilePath(path.toString());
	}	
	
	public ExportMessage[] getSelectedMessages() {
		return dialogArea.getSelectedMessages();
	}
}
