/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.Header;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.HeaderTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class HTTPHeaderTreeNode extends AbstractTreeNode {
	private static final String HTTP_HEADER =
		Messages.getString("httpHeaderTreeNode.httpHeaders"); //$NON-NLS-1$		

	private static final String ADD_HEADER =
		Messages.getString("httpHeaderTreeNode.addHeader"); //$NON-NLS-1$
	
	public HTTPHeaderTreeNode(Event event) {
		super(event);
	}

	public Header[] getLocalHeaders() {
		return (Header[]) maskatElement.getTypedChildren(
				Header.class).toArray(new Header[0]);
	}

	public Header[] getGlobalHeaders() {
		MaskatElement basicDef = maskatElement.getParent();
		EventDef eventDef = null;

		if (basicDef instanceof Component) {
			eventDef = (EventDef) basicDef.getParent();
		} else if (basicDef instanceof EventDef) {
			eventDef = (EventDef) basicDef;
		}
		return (Header[]) eventDef.getTypedChildren(
					Header.class).toArray(new Header[0]); 
	}

	protected void loadChildren() {
		Header[] headers = getLocalHeaders();
		for (int i = 0; i < headers.length; i++) {
			addChild(new HeaderTreeNode(headers[i], false));
		}

		Header[] globalHeaders = getGlobalHeaders();
		for (int i = 0; i < globalHeaders.length; i++) {
			addChild(new HeaderTreeNode(globalHeaders[i], true));
		}
	}

	public String getDisplayText() {
		return HTTP_HEADER;
	}
	
	/**when the child was removed, the Header bean of the child will be destroyed*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		//destroy the header bean
		Event event = (Event)maskatElement;
		if (((HeaderTreeNode)child).getModel().getParent() instanceof EventDef){
			((HeaderTreeNode)child).getModel().getParent().removeChild(child.getModel());
		}else {
			event.removeChild(child.getModel());
		}
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		if (!((HeaderTreeNode)child).isGlobal()) {
			maskatElement.addChild(child.getModel());
		}else{
			if (maskatElement.getParent() instanceof EventDef) {
				maskatElement.getParent().addChild(child.getModel());
			}else {
				maskatElement.getParent().getParent().addChild(child.getModel());
			}
		}
	}
	
	public boolean isDeletable() {
		return false;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		manager.add(new Action(ADD_HEADER){
			public void run() {
				//default,we add it as a local header.
				Header header = new Header();
				//header.setName("headerName");
				//header.setValue("");
				ITreeNode childNode = new HeaderTreeNode(header,false); 
				EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
			}
		});
		return super.fillContextMenu(treeViewer, manager);
	}
}
