/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.masterdetails;

import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ResultTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;


public class ResultDetailsPage extends AbstractMaskatDetailsPage {

	private static final String ROOT_NODE_SECTION_TEXT = Messages
			.getString("resultDetails.rootSectionText"); //$NON-NLS-1$

	private static final String ROOT_NODE_SECTION_DESCRIPTION = Messages
			.getString("resultDetails.rootDescription"); //$NON-NLS-1$

	private static final String SOAP_SECTION_TEXT = Messages
			.getString("resultDetails.soapSectionText"); //$NON-NLS-1$

	private static final String SOAP_SECTION_DESCRIPTION = Messages
			.getString("resultDetails.soapDescription"); //$NON-NLS-1$

	private static final String CALLBACK_FUNCTION_SECTION_TEXT = Messages
			.getString("resultDetails.callbackSectionText"); //$NON-NLS-1$

	private static final String CALLBACK_FUNCTION_SECTION_DESCRIPTION = Messages
			.getString("resultDetails.callbackDescription"); //$NON-NLS-1$

	private Section resultSection;

	private Text rootNodeText;

	private Text namespaceText;
	
	private Section soapSection;

	private Button soapButton;

	private Text callbackFunctionText;

	private Section callbackFunctionSection;

	private Result result;

	public ResultDetailsPage(TreeViewer treeViewer) {
		this.masterBlockTreeViewer = treeViewer;
	}

	public void createContents(Composite parent) {
		TableWrapLayout layout = new TableWrapLayout();
		layout.topMargin = 0;
		layout.leftMargin = 5;
		layout.rightMargin = 5;
		layout.bottomMargin = 5;
		parent.setLayout(layout);

		FormToolkit toolkit = managedForm.getToolkit();

		resultSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		resultSection.setText(ROOT_NODE_SECTION_TEXT);
		resultSection.setDescription(ROOT_NODE_SECTION_DESCRIPTION);
		TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL,
				TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		resultSection.setLayoutData(tableWrapData);

		soapSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		soapSection.setText(SOAP_SECTION_TEXT);
		soapSection.setDescription(SOAP_SECTION_DESCRIPTION);
		tableWrapData = new TableWrapData(TableWrapData.FILL, TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		soapSection.setLayoutData(tableWrapData);

		callbackFunctionSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		callbackFunctionSection.setText(CALLBACK_FUNCTION_SECTION_TEXT);
		callbackFunctionSection
				.setDescription(CALLBACK_FUNCTION_SECTION_DESCRIPTION);
		tableWrapData = new TableWrapData(TableWrapData.FILL, TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		callbackFunctionSection.setLayoutData(tableWrapData);

		Composite resultComposite = toolkit.createComposite(resultSection);
		resultComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(resultComposite, Messages
				.getString("resultDetails.nodeNameLabel")); //$NON-NLS-1$
		toolkit.createLabel(resultComposite, ":");
		rootNodeText = toolkit.createText(resultComposite, "", SWT.SINGLE
				| SWT.BORDER);
		rootNodeText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		toolkit.createLabel(resultComposite, Messages
				.getString("resultDetails.namespaceLabel")); //$NON-NLS-1$
		toolkit.createLabel(resultComposite, ":");
		namespaceText = toolkit.createText(resultComposite, "",
				SWT.SINGLE | SWT.BORDER);
		namespaceText.setLayoutData(new GridData(SWT.FILL, 0, true, false));
		
		Composite soapComposite = toolkit.createComposite(soapSection);
		soapComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(soapComposite, Messages
				.getString("resultDetails.soapLabel")); //$NON-NLS-1$
		toolkit.createLabel(soapComposite, ":");
		soapButton = toolkit.createButton(soapComposite, "", SWT.CHECK);

		Composite callbackFunctionComposite = toolkit
				.createComposite(callbackFunctionSection);
		callbackFunctionComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(callbackFunctionComposite, Messages
				.getString("resultDetails.onErrMsgLabel")); //$NON-NLS-1$
		toolkit.createLabel(callbackFunctionComposite, ":");
		callbackFunctionText = toolkit.createText(callbackFunctionComposite,
				"", SWT.SINGLE | SWT.BORDER);
		callbackFunctionText.setLayoutData(new GridData(SWT.FILL, 0, true,
				false));

		rootNodeText.addKeyListener(new KeyAdapter() {

			private int oldCaretPosition;

			public void keyReleased(KeyEvent e) {
				if (!rootNodeText.getText().equals("")) {
					if (result.getRootNode() == null
							|| !result.getRootNode().equals(
									rootNodeText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "rootNode",
								rootNodeText.getText());
					}
				} else {
					if (result.getRootNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "rootNode", null);
					}
				}
				oldCaretPosition = rootNodeText.getCaretPosition();
				updateTreeViewer();
				rootNodeText.setSelection(oldCaretPosition);
			}
		});

		rootNodeText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!rootNodeText.getText().equals("")) {
					if (result.getRootNode() == null
							|| !result.getRootNode().equals(
									rootNodeText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "rootNode",
								rootNodeText.getText());
						updateTreeViewer();
					}
				} else {
					if (result.getRootNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "rootNode", null);
						updateTreeViewer();
					}
				}
			}
		});

		namespaceText.addKeyListener(new KeyAdapter() {

			public void keyReleased(KeyEvent e) {
				if (result.getNs() == null
						|| !result.getNs().equals(namespaceText.getText())) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ResultTreeNode.class, result, "ns", namespaceText
									.getText());
				}
			}
		});
	

		namespaceText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!namespaceText.getText().equals("")) {
					if (result.getNs() == null
							|| !result.getNs().equals(namespaceText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "ns", namespaceText
										.getText());
					}
				} else {
					if (result.getNs() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "ns", null);
					}
				}
			}
		});		
		
		soapButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				if (result.isSoap() != soapButton.getSelection()) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ResultTreeNode.class, result, "soap", String
									.valueOf(soapButton.getSelection()));
				}
			}
		});

		callbackFunctionText.addKeyListener(new KeyAdapter() {

			public void keyReleased(KeyEvent e) {
				if (result.getOnErrorTele() == null
						|| !result.getOnErrorTele().equals(
								callbackFunctionText.getText())) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ResultTreeNode.class, result, "onErrorTele",
							callbackFunctionText.getText());
				}
			}
		});

		callbackFunctionText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!callbackFunctionText.getText().equals("")) {
					if (result.getOnErrorTele() == null
							|| !result.getOnErrorTele().equals(
									callbackFunctionText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "onErrorTele",
								callbackFunctionText.getText());
					}
				} else {
					if (result.getOnErrorTele() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ResultTreeNode.class, result, "onErrorTele",
								null);
					}
				}
			}
		});

		resultSection.setClient(resultComposite);

		soapSection.setClient(soapComposite);

		callbackFunctionSection.setClient(callbackFunctionComposite);
	}

	protected void initializeInterface() {
		update();
		setStaleFlag(false);
	}

	protected void update() {
		if (result.getRootNode() != null) {
			rootNodeText.setText(result.getRootNode());
		} else {
			rootNodeText.setText("");
		}
		if (result.getNs() != null) {
			namespaceText.setText(result.getNs());
		} else {
			namespaceText.setText("");
		}
		soapButton.setSelection(result.isSoap());

		if (result.getOnErrorTele() != null) {
			callbackFunctionText.setText(result.getOnErrorTele());
		} else {
			callbackFunctionText.setText("");
		}

		setDirtyFlag(false);
	}

	public void setResult(Result result) {
		this.result = result;
	}

	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				result, ResultTreeNode.class);
		if (treeNode != null) {
			masterBlockTreeViewer.update(treeNode, null);
			masterBlockTreeViewer.setSelection(
					new StructuredSelection(treeNode), true);
		}
	}
}
