/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.masterdetails;

import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ParamTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;


public class ParamDetailsPage extends AbstractMaskatDetailsPage {

	private static final String MESSAGE_TO_BE_SENT_SECTION_TEXT = Messages
			.getString("paramDetails.msgSectionText"); //$NON-NLS-1$

	private static final String MESSAGE_TO_BE_SENT_DESCRIPTION = Messages
			.getString("paramDetails.msgDescription"); //$NON-NLS-1$

	private static final String SOAP_SECTION_TEXT = Messages
			.getString("paramDetails.soapSectionText"); //$NON-NLS-1$

	private static final String SOAP_SECTION_DESCRIPTION = Messages
			.getString("paramDetails.soapDescription"); //$NON-NLS-1$

	private Param param;

	private Text rootNodeText;

	private Text namespaceText;

	private Button soapButton;

	public ParamDetailsPage(TreeViewer treeViewer) {
		this.masterBlockTreeViewer = treeViewer;
	}

	public void createContents(Composite parent) {
		TableWrapLayout layout = new TableWrapLayout();
		layout.topMargin = 0;
		layout.leftMargin = 5;
		layout.rightMargin = 5;
		layout.bottomMargin = 5;
		parent.setLayout(layout);

		FormToolkit toolkit = managedForm.getToolkit();

		/*
		 * Root node section
		 */
		Section messageToBeSentSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		messageToBeSentSection.setText(MESSAGE_TO_BE_SENT_SECTION_TEXT);
		messageToBeSentSection.setDescription(MESSAGE_TO_BE_SENT_DESCRIPTION);
		TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL,
				TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		messageToBeSentSection.setLayoutData(tableWrapData);

		Composite messageToBeSentComposite = toolkit
				.createComposite(messageToBeSentSection);
		messageToBeSentComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(messageToBeSentComposite, Messages
				.getString("paramDetails.nodeNameLabel")); //$NON-NLS-1$
		toolkit.createLabel(messageToBeSentComposite, ":");
		rootNodeText = toolkit.createText(messageToBeSentComposite, "",
				SWT.SINGLE | SWT.BORDER);
		rootNodeText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		toolkit.createLabel(messageToBeSentComposite, Messages
				.getString("paramDetails.namespaceLabel")); //$NON-NLS-1$
		toolkit.createLabel(messageToBeSentComposite, ":");
		namespaceText = toolkit.createText(messageToBeSentComposite, "",
				SWT.SINGLE | SWT.BORDER);
		namespaceText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		/*
		 * Soap section
		 */
		Section soapSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		soapSection.setText(SOAP_SECTION_TEXT);
		soapSection.setDescription(SOAP_SECTION_DESCRIPTION);
		tableWrapData = new TableWrapData(TableWrapData.FILL, TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		soapSection.setLayoutData(tableWrapData);

		Composite soapComposite = toolkit.createComposite(soapSection);
		soapComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(soapComposite,
				Messages.getString("paramDetails.soapLabel")).pack(); //$NON-NLS-1$
		toolkit.createLabel(soapComposite, ":").pack();
		soapButton = toolkit.createButton(soapComposite, "", SWT.CHECK);

		rootNodeText.addKeyListener(new KeyAdapter() {

			public void keyReleased(KeyEvent e) {
				if (param.getRootNode() == null
						|| !param.getRootNode().equals(rootNodeText.getText())) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ParamTreeNode.class, param, "rootNode",
							rootNodeText.getText());

					int oldCaretPosition = rootNodeText.getCaretPosition();
					updateTreeViewer();
					rootNodeText.setSelection(oldCaretPosition);
				}
			}
		});

		rootNodeText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!rootNodeText.getText().equals("")) {
					if (param.getRootNode() == null
							|| !param.getRootNode().equals(
									rootNodeText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ParamTreeNode.class, param, "rootNode",
								rootNodeText.getText());
					}
				} else {
					if (param.getRootNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ParamTreeNode.class, param, "rootNode", null);
					}
				}

				updateTreeViewer();
			}
		});

		namespaceText.addKeyListener(new KeyAdapter() {

			public void keyReleased(KeyEvent e) {
				if (param.getNs() == null
						|| !param.getNs().equals(namespaceText.getText())) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ParamTreeNode.class, param, "ns", namespaceText
									.getText());
				}
			}
		});

		namespaceText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				if (!namespaceText.getText().equals("")) {
					if (param.getNs() == null
							|| !param.getNs().equals(namespaceText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ParamTreeNode.class, param, "ns", namespaceText
										.getText());
					}
				} else {
					if (param.getNs() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								ParamTreeNode.class, param, "ns", null);
					}
				}
			}
		});

		soapButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				if ((!param.isSoap() && soapButton.getSelection())
						|| (param.isSoap() && !soapButton.getSelection())) {
					EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
							ParamTreeNode.class, param, "soap", String
									.valueOf(soapButton.getSelection()));
				}
			}
		});

		messageToBeSentSection.setClient(messageToBeSentComposite);

		soapSection.setClient(soapComposite);
	}

	public void update() {
		if (param.getRootNode() != null) {
			rootNodeText.setText(param.getRootNode());
		} else {
			rootNodeText.setText("");
		}

		if (param.getNs() != null) {
			namespaceText.setText(param.getNs());
		} else {
			namespaceText.setText("");
		}
		soapButton.setSelection(param.isSoap());

		setDirtyFlag(false);

	}

	public void setParam(Param param) {
		this.param = param;
	}

	protected void initializeInterface() {
		update();
		setStaleFlag(false);
	}

	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				param, ParamTreeNode.class);
		if (treeNode != null) {
			masterBlockTreeViewer.update(treeNode, null);
			masterBlockTreeViewer.setSelection(
					new StructuredSelection(treeNode), true);
		}
	}
}
