/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class SetEventPropertyCommand extends SetPropertyCommand {
	
	private Class classType;
	
	private TreeViewer treeViewer;
	
	private boolean refresh = true;
	
	/***
	 * @param classType class of the treeNode corresponding to the detailpage, who should be refreshed
	 * @param bean the MaskatElement bean
	 * @param propertyName 
	 * @param newValue
	 */
	public SetEventPropertyCommand(TreeViewer treeViewer, Class classType,
			Object bean, String propertyName, Object newValue) {
		this(treeViewer, classType, bean, propertyName, newValue, true);
	}

	public SetEventPropertyCommand(TreeViewer treeViewer, Class classType,
			Object bean, String propertyName, Object newValue,  boolean refresh) {
		super(bean, propertyName, newValue);
		this.treeViewer = treeViewer;
		this.classType = classType;
		this.refresh = refresh;
	}
	
	public Class getClassType() {
		return classType;
	}
	
	public Object getBean() {
		return bean;
	}
	
	public void redo() {
		try {
			super.redo();
			if (this.refresh) {
				updateTree();
			}
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));	
			
		}		
	}
	
	public void undo() {
		try {
			super.undo();
			if (this.refresh) {
				updateTree();
			}
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));	

		}
	}
	
	public boolean isRefresh() {
		return refresh;
	}

	public void setRefresh(boolean refresh) {
		this.refresh = refresh;
	}

	private void updateTree() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)bean, classType);
		if (treeNode instanceof EventTreeNode) {
			treeViewer.refresh(treeNode.getParent(), true);
			treeViewer.expandToLevel(2);
			treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)bean, classType);
			treeViewer.setSelection(new StructuredSelection(treeNode), true);			
		}else if (treeNode != null) {
			treeViewer.update(treeNode, null);
			treeViewer.setSelection(new StructuredSelection(treeNode), true);
		}
	}
}
