/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetChildNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteTargetNodeCommand extends DeleteOneTreeNodeCommand {
	private Target target = null;
	
	public DeleteTargetNodeCommand(TreeViewer treeViewer, ITreeNode parent, ITreeNode nodeToBeDeleted) {
		super(treeViewer, parent, nodeToBeDeleted);
	}

	public void execute() {
		if (nodeToBeDeleted.getModel() instanceof Target) {
			try {
				Target model = (Target) nodeToBeDeleted.getModel();
				this.target = (Target) model.clone();
			} catch (Exception e) {
				MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
			}
		}
		super.execute();
	}

	public void undo() {
		if (nodeToBeDeleted.getModel() instanceof Target) {
			Target model = (Target) nodeToBeDeleted.getModel();
			if (nodeToBeDeleted instanceof TargetChildNode) {
				model.setInkey(this.target.getInkey());
			}
		}
		super.undo();
	}
}
