/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Header;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ChangeEventTypeCommand extends Command {

	private TreeViewer treeViewer;
	
	private Event event;
	
	private String type;
	
	private Event oldEvent;
	
	public ChangeEventTypeCommand(TreeViewer treeViewer, Event event, String type) {
		super();
		try {
			this.treeViewer = treeViewer;
			this.event = event;
			this.oldEvent = (Event) event.clone();
			this.type = type;
			
		} catch (CloneNotSupportedException e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			if ("disable".equals(this.type) ) {
				cleanEvent(this.event);
			} else	if ("local".equals(this.type)) {
				makeEventLocal(this.event);
			} else {
				makeEventRemote(this.event);
			}
			ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
					(MaskatElement) this.event, EventTreeNode.class);
			
			if (treeNode instanceof EventTreeNode) {
				this.treeViewer.refresh(treeNode.getParent(), true);
				this.treeViewer.expandToLevel(2);
				treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
						(MaskatElement) this.event, EventTreeNode.class);
				this.treeViewer.setSelection(new StructuredSelection(treeNode), true);
			}
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		try {
			ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
					(MaskatElement) this.event, EventTreeNode.class);
			
			if (treeNode instanceof EventTreeNode) {
				setEvnetProperties(this.oldEvent, this.event);
				this.treeViewer.refresh(treeNode.getParent(), true);
				this.treeViewer.expandToLevel(2);
				treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
						(MaskatElement) this.event, EventTreeNode.class);
				this.treeViewer.setSelection(new StructuredSelection(treeNode), true);
			}
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}
	
	private void cleanEvent(Event event) {
		event.removeAllChildren();
		event.setRemoteUrl(null);
		event.setStart(null);
		event.setBefore(null);
		event.setAfter(null);
		event.setFinish(null);
		event.setTimeout(Event.TIMEOUT_DEFAULT);
		event.setAsync(Event.ASYNC_DEFAULT);
		event.setOnTimeoutError(null);
		event.setAfter(null);
		event.setEnable(false);
	}
	
	private void setEvnetProperties(Event old, Event event) {
		event.removeAllChildren();
		List chirdren = new ArrayList(old.getChildren());
		for (int i = 0; i < chirdren.size(); i++) {
			event.addChild(chirdren.get(i));
		}
		event.setEnable(old.isEnable());
		event.setType(old.getType());
		event.setRemoteUrl(old.getRemoteUrl());
		event.setStart(old.getStart());
		event.setBefore(old.getBefore());
		event.setAfter(old.getAfter());
		event.setFinish(old.getFinish());
		event.setTimeout(old.getTimeout());
		event.setOnTimeoutError(old.getOnTimeoutError());
		event.setEnable(old.isEnable());
		event.setAsync(old.isAsync());
	}

	private void makeEventRemote(Event event) {
		event.setEnable(true);
		event.setType("remote");
		Result result = event.getResult();
		if (result != null) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				targets[i].setTeleType(targets[i].getWorkType());
				targets[i].setWorkType(null);
				targets[i].setType("local");
			}
		}
	}

	private void makeEventLocal(Event event) {
		event.setEnable(true);
		event.setType("local");
		event.setBefore(null);
		event.setAfter(null);
		event.setRemoteUrl(null);

		//set to default value so that it will not be saved
		event.setTimeout(Event.TIMEOUT_DEFAULT);
		event.setAsync(Event.ASYNC_DEFAULT);
		event.setOnTimeoutError(null);

		if (event.getTypedChildren(Param.class) != null) {
			// delete param
			Param param = event.getParam();
			param.setEnable(false);
			param.removeAllChildren();
			param.setNs(null);
			param.setRootNode(null);
		}
		if (event.getTypedChildren(Result.class) != null) {
			// delete remote data binding
			Result result = event.getResult();
			result.setEnable(false);
	
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				if ("remote".equals(targets[i].getType())) {
					result.removeChild(targets[i]);
				} else {
					targets[i].setWorkType(targets[i].getTeleType());
					targets[i].setTeleType(null);					
				}
			}
			result.setRootNode(null);
			result.setOnErrorTele(null);
		}
		event.removeAllByType(Header.class);
	}
}
