/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Bind;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.action.DeleteTargetNodeAction;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;

public class TargetChildNode extends AbstractTreeNode {
	private static final String ROW_LABEL =
		Messages.getString("sourceChildNode.rowLabel"); //$NON-NLS-1$		

	private static final String ADD_BIND_NODE =
		Messages.getString("sourceChildNode.addBindNode"); //$NON-NLS-1$
	
	public TargetChildNode(Target target) {
		super(target);
	}
	
	protected void loadChildren() {
		Bind[] binds = ((Target) maskatElement).getBinds();
		for (int i = 0; i < binds.length; i++) {
			addChild(new TargetBind(binds[i]));
		}
	}
	
	/**destroy the Bind bean of the child after remove the child*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		maskatElement.removeChild(child.getModel());
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		maskatElement.addChild(child.getModel());
	}

	public String getDisplayText() {
		if(maskatElement == null 
			|| ((Target) maskatElement).getInkey() == null
			|| ((Target) maskatElement).getInkey().length() == 0) {
			return "<> " + ROW_LABEL;
		}
		return ((Target) maskatElement).getInkey() + " " + ROW_LABEL;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		manager.add(new Action(ADD_BIND_NODE){
			public void run() {
				Bind bind = new Bind();
				bind.setTokey("");
				bind.setNode("");
				ITreeNode childNode = new TargetBind(bind);
				EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));				
			}
		});
		manager.add(new Separator()); 
	 	manager.add(new DeleteTargetNodeAction(treeViewer, this));
	 	return manager;
	}
}
