/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.action;

import java.util.ArrayList;
import java.util.Iterator;

import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.command.DeleteMultiTreeNodesCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteMultiNodesAction extends AbstractAction {

	public DeleteMultiNodesAction(TreeViewer treeViewer) {
		super(treeViewer);
	}
	
	public String getText() {
		return Messages.getString("deleteMultiNodesAction.deleteLabel"); //$NON-NLS-1$
	}
	
	public ImageDescriptor getImageDescriptor() {
		return null;
	}
	
	public void run() {
		IStructuredSelection sel = (IStructuredSelection) treeViewer.getSelection();
		if (sel.isEmpty())
			return;
		
		ArrayList treeNodes = new ArrayList();
		for (Iterator iter = sel.iterator(); iter.hasNext();) {
			ITreeNode node = (ITreeNode)iter.next();
			if(!node.isDeletable()) {
				continue;
			}
			treeNodes.add(node);
		}
		EventPropertiesMasterDetailsBlock.executeCommand(new DeleteMultiTreeNodesCommand(
				treeViewer, (ITreeNode[]) treeNodes.toArray(new ITreeNode[0])));
	}

}
