/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;

import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class LabelTextCellEditor extends TextCellEditor
	implements DirectEditable {
	
	LabelDirectEditable editable;
	
	public LabelTextCellEditor(Composite parent, int style, LabelDirectEditable editable) {
        super(parent, style);
        this.editable = editable;
    }
	
	public String get() {
		return editable.getLabel();
	}
	
	public void set(String id) {
		editable.setLabel(id);
	}
}
