/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class IdDirectEditmanger extends TextDirectEditManager {
	Composite viewSource;
	
	public IdDirectEditmanger(GraphicalEditPart source, Composite comp,
			CellEditorLocator locator) {
		super(source, null, locator);
		viewSource = comp;
	}

	protected CellEditor createCellEditorOn(Composite composite) {
		return new IdTextCellEditor(viewSource, SWT.SINGLE | SWT.WRAP, getEditPart());
	}

	protected void initCellEditor() {
		IdDirectEditable direct = (IdDirectEditable)
			getEditPart().getAdapter(IdDirectEditable.class);
		
		getCellEditor().setValue((direct.getId() == null) ? "" : direct.getId());
	}	
	
	public void showFeedback() {}
}
