/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import org.eclipse.gef.tools.CreationTool;

/**
 * パレットから部品を配置するクリエーションツールです。
 * 
 * コントロールキーを押しながらパレットから配置すると連続配置モードとなります。
 */
public class AdvancedCreationTool extends CreationTool {

	protected void handleFinished() {
		if (unloadWhenFinished() && !getCurrentInput().isControlKeyDown()) {
			getDomain().loadDefaultTool();
		} else {
			reactivate();
		}
	}
}
