/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * パレットから配置する部品のクリエーションエントリクラスです。
 * 
 * 生成するクリエーションツールを拡張された AdvancedCreationTool クラスを
 * 利用します。
 */
public class AdvancedCreationEntry extends CombinedTemplateCreationEntry {

	public AdvancedCreationEntry(String label, String shortDesc,
			CreationFactory factory, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
		super(label, shortDesc, factory, iconSmall, iconLarge);
		setToolClass(AdvancedCreationTool.class);
	}

	public AdvancedCreationEntry(String label, String shortDesc, Object template,
			CreationFactory factory, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
		super(label, shortDesc, template, factory, iconSmall, iconLarge);
		setToolClass(AdvancedCreationTool.class);
	}
}
