/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.requests;

import org.eclipse.gef.Request;

public class DataBindingRequest extends Request {

	public static final String REQ_DATA_BINDING = "data binding";

	public DataBindingRequest(Object bean, String propertyName) {
		super(REQ_DATA_BINDING);
		getExtendedData().put("bean", bean);
		getExtendedData().put("propertyname", propertyName);
	}

	public Object getBean() {
		return getExtendedData().get("bean"); 
	}
	
	public String getPropertyName() {
		return (String) getExtendedData().get("propertyname"); 
	}
}
