/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Desc;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.Evaluator;
import jp.sf.maskat.core.layout.JavaScript;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.UnknownComponent;
import jp.sf.maskat.ui.ISharedImages;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.DynaComponentEditPartFactory;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.ui.views.properties.AbstractComponentPropertySource;
import jp.sf.maskat.ui.views.properties.DynaBeanPropertySource;
import jp.sf.maskat.ui.views.properties.LayoutPropertySource;

import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;


public class OutLineTreeEditPart extends AbstractTreeEditPart 
	implements PropertyChangeListener {
	
	private EditPart layoutEditPart = null;
	
	private Image image = null;

	public OutLineTreeEditPart(EditPart layoutPart) {
		this.layoutEditPart = layoutPart;
	}
	
	public void activate() {
		super.activate();
		if (getModel() instanceof Component) {
			((Component) getModel()).addPropertyChangeListener(this);
		}
	}

	public void deactivate() {
		if (getModel() instanceof Component) {
			((Component) getModel()).removePropertyChangeListener(this);
		}
		super.deactivate();
	}

	
	public void propertyChange(PropertyChangeEvent evt) {
		String name = evt.getPropertyName();
		if ("addChild".equals(name) || "removeChild".equals(name)) { //$NON-NLS-1$
			refresh();
		} else 	if ("gridHeaderTitle".equals(name)) { //$NON-NLS-1$
			for (Iterator it = this.getChildren().iterator(); it != null
				&& it.hasNext();) {
				((EditPart) it.next()).refresh();
			}
		}
		refreshVisuals();
	}

	protected List getModelChildren() {
		List result = null;
		Object model = getModel();
		if (model instanceof MaskatElement) {
			result = ((MaskatElement) model).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}

	protected void refreshVisuals() {
		setWidgetText(getOutlineLabel());
		setWidgetImage(getOutlineImage());
	}

	protected void createEditPolicies() {
		EditPolicy newPolicy = null;
		if (layoutEditPart != null) {
			GraphicalEditPart editPart = (GraphicalEditPart) layoutEditPart;
			EditPolicy policy = editPart.getEditPolicy(EditPolicy.COMPONENT_ROLE);
			if (policy != null) {
				if (policy instanceof MaskatComponentEditPolicy) {
					newPolicy = ((MaskatComponentEditPolicy) policy).cloneEditPolicy();
				} else {
					newPolicy = new MaskatComponentEditPolicy();
					newPolicy.setHost(policy.getHost());
				}
			} else {
				newPolicy = new MaskatComponentEditPolicy();
			}
		}
		installEditPolicy(EditPolicy.COMPONENT_ROLE, newPolicy);
	}

	public void setLayoutEditPart(EditPart editPart) {
		layoutEditPart = editPart;
	}
	
	public EditPart getLayoutEditPart() {
		return layoutEditPart;
	}
	
	public Object getAdapter(Class key) {
		if (key.equals(IPropertySource.class)) {
			Object object = Platform.getAdapterManager().getAdapter(getModel(), key);
			if (object instanceof AbstractComponentPropertySource) {
				((AbstractComponentPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			}else if (object instanceof LayoutPropertySource) {
				((LayoutPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			}else if (object instanceof DynaBeanPropertySource) {
				((DynaBeanPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			} 
			return object;
		} else if (key.isAssignableFrom(getModel().getClass())) {
			return getModel();
		}
		return super.getAdapter(key);
	}
	
	private String getOutlineLabel() {
		Object model = getModel();
		if (model == null) {
			return null;
		}
		if (layoutEditPart != null && layoutEditPart instanceof LayoutElementEditPart) {
			return ((LayoutElementEditPart) layoutEditPart).getOutlineLabel();
		}
		StringBuffer sb = new StringBuffer(" "); //$NON-NLS-1$
		String className = null;
		if (model instanceof UnknownComponent) {
			className = ((UnknownComponent) model).getDynaClass().getName();
		} else if (model instanceof DynaComponent) {
			className = ((DynaComponent) model).getDynaClass().getName();
		} else {
			className = model.getClass().getName();
		}
		className = className.substring(className.lastIndexOf(".") + 1); //$NON-NLS-1$
		sb.append(className);
		return sb.toString();
	}
	
	private Image getOutlineImage() {
		if (image != null) {
			return image;
		}
		Object model = getModel();
		if (model instanceof Layout) {
			image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_LAYOUT);

		} else if (model instanceof JavaScript) {
			image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_JAVASCRIPT);

		} else if (model instanceof Desc) {
			image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_DESC);

		} else if (model instanceof Evaluator) {
			image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_EVALUATOR);
						
		} else if (model instanceof DynaComponent) {
			ImageDescriptor desc = DynaComponentEditPartFactory.getImageDescriptor(model);
			if (desc == null) {
				image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_CUSTOM);
			} else {
				image = desc.createImage();
			}
		} else {
			image = MaskatUIPlugin.getImage(ISharedImages.IMG_COMPONENT_UNKNOWN);
		}

		return image;
	}
}
