/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DragTracker;
import org.eclipse.swt.graphics.Image;

public class PopupBarDescriptor {
	/** The action button tooltip */
	private String tooltip = "";

	/** The image for the button */
	private Image icon = null;

	/** The DracgTracker / Tool associatd with the popup bar button */
	private DragTracker dragTracker = null;

	private Dimension size;
	
	/**
	 * constructor
	 * @param s
	 * @param i
	 * @param elementType
	 * @param theTracker
	 */
	public PopupBarDescriptor(
			String s,
			Image i,
			Dimension d,
			DragTracker theTracker) {
		tooltip = s;
		icon = i;
		dragTracker = theTracker;
		size = d;
	}

	/**
	 * gets the icon associated with this Descriptor
	 * @return Image
	 */
	public final Image getIcon() {
		return icon;
	}

	/**
	 * gets the drag tracker associated with this Descriptor
	 * @return drag tracker
	 */
	public final DragTracker getDragTracker() {
		return dragTracker;
	}

	/**
	 * gets the tool tip associated with this Descriptor
	 * @return string
	 */
	public final String getToolTip() {
		return tooltip;
	}
	
	public final Dimension getDimension() {
		return size;
	}
}
