/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Container;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.ui.editors.layout.commands.DelBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;

//import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
//import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
//import org.eclipse.gef.requests.ChangeBoundsRequest;
//import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
//import org.eclipse.swt.graphics.Color;


public class MaskatComponentEditPolicy extends ComponentEditPolicy {
	
//	private boolean defaultOpaque = false;
//	private Color defaultBgColor = null;
	

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		Object model = getHost().getModel();
		if (model instanceof Component) {
			Component comp = (Component) model;
			if (comp instanceof Layout) {
				return null;
			}
			EditPart part = getHost();
			if (part instanceof LayoutElementEditPart) {
				if (!((LayoutElementEditPart) part).canDelete()) {
					return null;
				}
			}
			return new DelBasicDefCommand(comp.getParent(), comp);
		}
		return null;
	}

	protected boolean canFeedbackToRequest(Request request) {
		Object model = getHost().getModel();
		if (model instanceof Container && !(model instanceof Layout)) {
			return true;
		}
		return false;
	}

//	public void showTargetFeedback(Request request) {
//		if (canFeedbackToRequest(request)) {
//			// TODO ChangeBoundsRequestの場合、EditPartは親EditPart内移動する場合、
//			// ハイライト表示はしないように
//			boolean doHighlight = false;
//			if (request instanceof CreateRequest
//					|| request instanceof ChangeBoundsRequest) {
//				doHighlight = true;
//			}
//			if (doHighlight) {
//				Color bgColor = ((AbstractGraphicalEditPart) getHost()).getFigure().getBackgroundColor();
//				if (bgColor != null && ! bgColor.equals(ColorConstants.lightGray)) {
//					defaultBgColor = ((AbstractGraphicalEditPart) getHost()).getFigure().getBackgroundColor();
//					defaultOpaque = ((AbstractGraphicalEditPart) getHost()).getFigure().isOpaque();
//				}
//				// ハイライト表示
//				((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
//						ColorConstants.lightGray);
//				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(true);
//			}
//		}
//		super.showTargetFeedback(request);
//	}

//	public void eraseTargetFeedback(Request request) {
//		if (canFeedbackToRequest(request)) {
//			if (request instanceof CreateRequest
//					|| request instanceof ChangeBoundsRequest) {
//				if (defaultBgColor != null) {
//					((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(defaultBgColor);
//					
//				} else {
//					((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
//							ColorConstants.white);
//				}
//				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(defaultOpaque);
//			}
//		}
//		super.eraseTargetFeedback(request);
//	}
	
	public EditPolicy cloneEditPolicy() {
		EditPolicy editPolicy = new MaskatComponentEditPolicy();
		editPolicy.setHost(getHost());
		return editPolicy;
	}
}
