/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.util.HashMap;
import java.util.Map;

import jp.sf.maskat.core.layout.Layout;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;


public class MaskatEditPartFactory implements EditPartFactory {

	private static Map factoryClasses;
	
	static {
		factoryClasses = new HashMap();
		factoryClasses.put(Layout.class, LayoutEditPart.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart editPart = null;
		Class modelClass = model.getClass();
		if (factoryClasses.containsKey(modelClass)) {
			try {
				Class editPartClass = (Class) factoryClasses.get(modelClass);
				editPart = (EditPart) editPartClass.newInstance();
				// モデルをEditPartに設定する
				editPart.setModel(model); 

			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return editPart;
	}
}
