/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Component;

import org.eclipse.gef.commands.Command;


public class DelBasicDefCommand extends Command {
	
	private MaskatElement parent;

	private MaskatElement child;

	private int index;

	private EventDef eventDef;

	private jp.sf.maskat.core.event.Component eventComponent;

	private boolean noAction = false;

	public DelBasicDefCommand(MaskatElement parent, MaskatElement child) {
		this.parent = parent;
		this.child = child;
	}

	public void execute() {

		index = parent.getChildIdx(child);
		parent.removeChild(child);

		if (child instanceof Component) {
			Component component = (Component) child;
			eventDef = component.getLayout().getLayoutDef().getEventDef();
			eventComponent = eventDef.findComponent(component.getName());
			if (eventComponent != null) {
				eventDef.removeChild(eventComponent);
			}
		}
	}

	public void undo() {
		if (noAction) {
			return;
		}
		parent.addChildToIdx(child, index);
		if (eventDef != null && eventComponent != null) {
			eventDef.addChild(eventComponent);
		}
	}

	public boolean canUndo() {
		return true;
	}
}
