/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

/**
 * IDEで利用するイメージキーの定義を行うクラスです 
 *
 *<p>
 * IDEでイメージを利用する場合には本クラスにキーを定義しMaskatUIPlugin#initializeImageRegistry
 * メソッドに以下のように記述することで利用します。。
 * reg.put(IMG_KEY, imageDescriptorFromPlugin(PLUGIN_ID, iconpath));
 * 
 * 利用する場合は以下のようにしてイメージの取得を行います 
 * ImageDescriptor img = MakstUIPlugin.getImageDescriptor(IMG_KEY);
 * </p>
 */
public interface ISharedImages {
	
	/**
	 * アウトラインで利用されるレイアウトイメージのキー
	 */
	public static final String IMG_COMPONENT_LAYOUT =
			"IMG_COMPONENT_AYOUT"; //$NON-NLS-1$
	
	/**
	 * イベントのエクスポートで利用されるイベント定義イメージのキー
	 */
	public static final String IMG_COMPONENT_TEXT =
			"IMG_COMPONENT_TEXT"; //$NON-NLS-1$

	/**
	 * アウトラインで利用されるデフォルトコンポーネントイメージのキー
	 */
	public static final String IMG_COMPONENT_CUSTOM =
			"IMG_COMPONENT_CUSTOM"; //$NON-NLS-1$

	/**
	 * アウトラインで利用される未知のコンポーネントイメージのキー
	 */
	public static final String IMG_COMPONENT_UNKNOWN =
			"IMG_COMPONENT_UNKNOWN"; //$NON-NLS-1$

	/**
	 * アウトラインで利用されるJavaScriptイメージのキー
	 */
	public static final String IMG_COMPONENT_JAVASCRIPT =
			"IMG_COMPONENT_JAVASCRIPT"; //$NON-NLS-1$

	/**
	 * アウトラインで利用されるコメントイメージのキー
	 */
	public static final String IMG_COMPONENT_DESC =
			"IMG_COMPONENT_DESC"; //$NON-NLS-1$

	/**
	 * アウトラインで利用されるEvaluatorイメージのキー
	 */
	public static final String IMG_COMPONENT_EVALUATOR =
			"IMG_COMPONENT_EVALUATOR"; //$NON-NLS-1$

	/**
	 * パレットで利用されるデフォルトコンポーネントイメージのキー
	 */
	public static final String IMG_COMPONENTICON =
			"IMG_COMPONENTICON"; //$NON-NLS-1$

	/**
	 * イベントエディタで利用される縦分割イメージのキー
	 */
	public static final String IMG_HORIZONTAL_ACTION =
			"IMG_HORIZONTAL_ACTION"; //$NON-NLS-1$

	/**
	 * イベントエディタで利用される横分割イメージのキー
	 */
	public static final String IMG_VERTICAL_ACTION =
			"IMG_VERTICAL_ACTION"; //$NON-NLS-1$

	/**
	 * イベントエディタで利用されるタグイメージのキー
	 */
	public static final String IMG_OBJ_ELEMENT =
			"IMG_OBJ_ELEMENT"; //$NON-NLS-1$

	/**
	 * PopupBarで利用されるバーイメージのキー
	 **/
	public static final String IMAGE_POPUPBAR = "IMAGE_POPUPBAR"; //$NON-NLS-1$
	public static final String IMAGE_POPUPBAR_PLUS = "IMAGE_POPUPBAR_PLUS"; //$NON-NLS-1$
	public static final String IMAGE_SEPARATOR = "IMAGE_SEPARATOR";	//$NON-NLS-1$
	
	/**
	 * 新規プロジェクト作成ウィザードで利用する新規プロジェクト作成イメージのキー
	 */
	public static final String IMG_WIZBAN_NEWPROJECT =
			"IMG_WIZBAN_NEWPROJECT"; //$NON-NLS-1$

	/**
	 * 新規アプリケーション作成ウィザードで利用する新規アプリケーション
	 * 作成イメージのキー
	 */
	public static final String IMG_WIZBAN_NEWAPPLICATION =
			"IMG_WIZBAN_NEWAPP"; //$NON-NLS-1$

	/**
	 * 新規レイアウト定義XML作成ウィザードで利用する新規レイアウト定義XML
	 * 作成イメージのキー
	 */
	public static final String IMG_WIZBAN_NEWFILE =
			"IMG_WIZBAN_NEWFILE"; //$NON-NLS-1$

	/**
	 * マスカットパースペクティブで利用するマスカットイメージのキー
	 */
	public static final String IMG_WIZBAN_MASKATFILE =
			"IMG_WIZBAN_MASKATFILE"; //$NON-NLS-1$

	/**
	 * 新規アプリケーションウィザードで利用されるコンテナHTMLイメージのキー
	 */
	public static final String IMG_WIZBAN_HTMLFILE =
			"IMG_WIZBAN_HTMLFILE"; //$NON-NLS-1$

	/**
	 * 新規アプリケーションウィザードでプラグインイメージのキー
	 */
	public static final String IMG_WIZBAN_PLUGIN =
			"IMG_WIZBAN_PLUGIN"; //$NON-NLS-1$

	/**
	 * 新規アプリケーションウィザードで必須プラグインイメージのキー
	 */
	public static final String IMG_WIZBAN_REQUIRED_PLUGIN =
			"IMG_WIZBAN_REQUIRED_PLUGIN"; //$NON-NLS-1$
}
