/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import jp.sf.maskat.core.event.Event;

import org.eclipse.core.runtime.CoreException;

/**
 * マスカットイベントハンドラの外部実装を呼び出すインターフェースです。
 * 
 * このインターフェースを持っているNatureをマスカットプロジェクトに
 * 追加することで呼び出しが可能となります。
 *  
 */
public interface EventEditorContributor {
	
	/**
	 * イベントハンドラの実装を呼び出します。
	 * 
	 * IDEイベントエディタの「ハンドラ実装を開く」リンクにより呼
	 * び出されるメソッドです。
	 * 
	 * @param event イベント
	 * @throws CoreException 実行時にエラーが発生した場合
	 */
	public void openEventHandlerImpl(Event event) throws CoreException;

	/*
	public void openLocalEventHandlerImpl(SelectionChangedEvent event)
			throws CoreException;
	
	public void openRequestXMLHandlerImpl(SelectionChangedEvent event)
			throws CoreException;
		
	public void openResponseXMLHandlerImpl(SelectionChangedEvent event)
			throws CoreException;
	*/
}
