/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.runtime;

import java.util.Map;

/**
 *  プラグイン固有のプロパティを定義するインターフェースです
 *  
 *  このクラスで定義されたプロパティはマスカットフレームワークで利用する
 *  properties.jsonに出力されます。
 *  出力はinitializeメソッドの第一引数 properties に対して追加します。
 *  
 * 	"pluginName": {
 * 		"enabled": true,
 *		"property1": value1,
 *		"property2": value2,
 *            :
 *	},
 *  
 *  上記のようなプロパティを追加する場合、以下のようなコードとなります。
 *  
 *  public void initialize(Map properties, boolean enabled) {
 *      Map property = new LinkedHashMap();
 *      properties.put("pluginName", property);
 *      property.put("enabled", enabled ? Boolean.TRUE : Boolean.FALSE);
 *      property.put("property1", "value1");
 *      property.put("property2", "value2");
 *  }
 *  
 *  引数 propertiesにはそれまで読み込んだ他プラグインのプロパティが格納
 *  されています。それらの情報を参照することも可能です。
 *  
 *  public void initialize(Map properties, boolean enabled) {
 *      Map property = properties.get("pluginName1");
 *      String value3 = property.get("property3");
 */
public interface PropertyInitializer {

	/**
	 * プラグイン固有のプロパティを定義します。
	 * 第一引数 properties に対してプロパティを追加する
	 * 
	 * @param properties プロパティ（マスカットプロパティ全体）
	 * @param enabled 有効 true, 無効 false
	 */
	public void initialize(Map properties, boolean enabled);
}
