/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.runtime;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * coreプラグイン固有のプロパティを定義するクラスです
 * 
 * このクラスでは以下のプラグインプロパティを出力します。
 * ・core
 * ・log4javascript
 * ・livevalidation
 */
public class CorePropertyInitializer implements PropertyInitializer {

    /**
     * {@inheritDoc}
     */
	public void initialize(Map properties, boolean enabled) {
		Map property = (Map) properties.get("core");
		if (property == null) {
			property = new LinkedHashMap();
			properties.put("core", property);
		}
		property.put("enabled", enabled ? Boolean.TRUE : Boolean.FALSE);
		property.put("comm.sendInterval", new Integer(100));
		property.put("comm.timeoutInterval", new Integer(500));
		property.put("comm.poolSize", new Integer(2));
		property.put("controller.src", "transition.xml");
		property.put("dialog.factory", "maskat.ui.JavaScriptDialogFactory");
		property.put("log.popup.focus", Boolean.FALSE);
		property.put("log.default.level", "INFO");
		property.put("log.factory", "maskat.log.SimpleLogFactory");
		property.put("variable.scope", "global");
		property.put("variable.widget", "unwrapped");

		Map log4jsProperty = (Map) properties.get("log4javascript");
		if (log4jsProperty == null) {
			log4jsProperty = new LinkedHashMap();
			properties.put("log4javascript", log4jsProperty);
		}
		log4jsProperty.put("enabled", Boolean.FALSE);

		Map livevalidationProperty = (Map) properties.get("livevalidation");
		if (livevalidationProperty == null) {
			livevalidationProperty = new LinkedHashMap();
			properties.put("livevalidation", livevalidationProperty);
		}
		livevalidationProperty.put("enabled", Boolean.FALSE);
		livevalidationProperty.put("floatMessageMarginTop", new Integer(10));
		livevalidationProperty.put("floatMessageMarginLeft", new Integer(10));
		livevalidationProperty.put("floatMessageMarginRight", new Integer(20));
	}
}
