/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import jp.sf.maskat.core.MaskatElement;

/**
 * レイアウト定義要素に関するインターフェースです
 * レイアウト関連の要素はこのインターフェースをインプリメント
 * する必要があります。
 */
public interface LayoutElement extends MaskatElement {

	/**
	 * この要素が属するレイアウト要素を取得します
	 * 
	 * @return この要素が属するレイアウト要素
	 */
	public Layout getLayout();
}
