/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.PredicateUtils;

/**
 * マスカット部品の動的に生成されるモデルクラスでありコンテナ部品を
 * 表現します。
 * 
 * DynaComponetクラスはorg.apache.commons.DynaBeanインターフェース
 * を実装しマスカット部品のJavaBeanオブジェクトとして利用されます。
 * 
 * このクラスは拡張ポイント「jp.sf.maskat.core.widgets」の定義を行う
 * ことで自動作成されます。静的にJavaBeanを作成する必要がありません。
 */
public class DynaContainer extends DynaComponent implements Container {

	/**
	 * シリアルバージョンUID
	 */
	private static final long serialVersionUID = -2266168287249156706L;

	/**
	 * デフォルトコンストラクタです
	 */
	public DynaContainer() {
		super();
	}

	/**
	 * コンストラクタです
	 * 
	 * @param dynaClass dynaClass ClassオブジェクトをシュミレーションしたDynaClass
	 */
	public DynaContainer(DynaClass dynaClass) {
		super(dynaClass);
	}

    /**
     * {@inheritDoc}
     */
	public List getComponents() {
		List result = new ArrayList();
		CollectionUtils.select(getRawChildren(), PredicateUtils
				.instanceofPredicate(Component.class), result);
		return result;
	}

}
