/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import jp.sf.maskat.core.AbstractMaskatElement;

/**
 * コメント要素のクラスです
 * 
 * レイアウト定義XMLのdescタグに該当するモデルクラスです
 */
public class Desc extends AbstractMaskatElement {

	/**
	 * コメント
	 */
	private String comment;

	/**
	 * デフォルトコンストラクタです
	 */
	public Desc() {
		super();
	}
	
	/**
	 * コメントを取得します
	 * 
	 * @return コメント
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * コメントを設定します
	 * 
	 * @param comment コメント
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}
}
