/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.util.List;

/**
 * コンテナ要素の抽象クラスです。
 * 
 * 動的に生成するDynaComponentを利用しないで静的にコンテナを
 * 拡張する場合、このクラスを継承する必要があります。
 */
public abstract class AbstractContainer extends AbstractComponent
		implements Container {

	/**
     * {@inheritDoc}
     */
	public void addChild(Object comp) {
		super.addChild(comp);
		firePropertyChange("addChild", "", null);
	}
	
	/**
     * {@inheritDoc}
     */
	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}
	
	/**
     * {@inheritDoc}
     */
	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		firePropertyChange("addChild", "", null);
	}

	/**
     * {@inheritDoc}
     */
	public List getComponents() {
		return getTypedChildren(AbstractComponent.class);
	}
}
