/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * リモートイベントで送信される要求メッセージのXML要素にバインド
 * するレイアウト部品または変数の対応付けを定義するクラスです。
 */
public class Source extends AbstractEventElement {

	/**
	 * 空要素の送信有無 （初期値）
	 */
	public static final boolean SEND_BLANK_ELEMENT_DEFAULT = false;

	/**
	 * 最小文字数（初期値）
	 */
	public static final int MIN_DEFAULT = -1;

	/**
	 * 最大文字数（初期値）
	 */
	public static final int MAX_DEFAULT = -1;

	/**
	 * オブジェクトのプロパティ（初期値）
	 */
	public static final String FROM_KEY_DEFAULT = "";

	/**
	 * バリデーションタイプ（初期値）
	 */
	public static final String TYPE_DEFAULT = "disabled";

	/**
	 * 参照オブジェクト名
	 * データ取得元となるGUIオブジェクト名もしくは変数名
	 */
	private String obj;

	/**
	 * HTTP要求メッセージに生成するXML要素名
	 */
	private String node;

	/**
	 * インデックス参照オブジェクト名
	 */
	private String idxRef;

	/**
	 * HTTP要求メッセージに生成される子ノード名
	 */
	private String childNode;

	/**
	 * 参照オブジェクトのプロパティ名
	 * obj属性で指定する参照オブジェクトに対してのプロパティ名
	 */
	private String fromkey = FROM_KEY_DEFAULT;

	/**
	 * バリデーションタイプ
	 */
	private String type;

	/**
	 * バリデーションの説明文
	 */
	private String desc;

	/**
	 * 最小文字数
	 */
	private int min = MIN_DEFAULT;

	/**
	 * 最大文字数
	 */
	private int max = MAX_DEFAULT;

	/**
	 * 入力規則の正規表現
	 */
	private String regexp;

	/**
	 * データ取得メソッド名
	 */
	private String teleType;

	/**
	 * 空要素の送信有無
	 */
	private boolean sendBlankElement = SEND_BLANK_ELEMENT_DEFAULT;

	/**
	 * デフォルトコンストラクタです
	 */
	public Source() {
		super();
	}
	
	/**
	 * バリデーションの説明文を取得します
	 * 
	 * @return バリデーションの説明文
	 */
	public String getDesc() {
		return desc;
	}

	/**
	 * バリデーションの説明文を設定します
	 * 
	 * @param desc バリデーションの説明文
	 */
	public void setDesc(String desc) {
		this.desc = desc;
	}

	/**
	 * 最大文字数を取得します
	 * 
	 * @return 最大文字数
	 */
	public int getMax() {
		return max;
	}

	/**
	 * 最大文字数を設定します
	 * 
	 * @param max 最大文字数
	 */
	public void setMax(int max) {
		this.max = max;
	}

	/**
	 * 最小文字数を取得します
	 * 
	 * @return 最小文字数
	 */
	public int getMin() {
		return min;
	}

	/**
	 * 最小文字数を設定します
	 * 
	 * @param min 最小文字数
	 */
	public void setMin(int min) {
		this.min = min;
	}

	/**
	 * 入力規則の正規表現を取得します
	 * 
	 * @return 入力規則の正規表現
	 */
	public String getRegexp() {
		return regexp;
	}

	/**
	 * 入力規則の正規表現を設定します
	 * 
	 * @param regexp 入力規則の正規表現
	 */
	public void setRegexp(String regexp) {
		this.regexp = regexp;
	}

	/**
	 * バリデーションタイプを取得します
	 * 
	 * @return バリデーションタイプ
	 */
	public String getType() {
		return type;
	}

	/**
	 * バリデーションタイプを設定します
	 * 
	 * @param type バリデーションタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * バインド要素を配列で取得します
	 * 
	 * @return バインド要素の配列
	 */
	public Bind[] getBinds() {
		return (Bind[]) getTypedChildren(Bind.class)
				.toArray(new Bind[0]);
	}

	/**
	 * 子ノード名を取得します
	 * 
	 * @return 子ノード名
	 */
	public String getChildNode() {
		return childNode;
	}

	/**
	 * 子ノード名を設定します
	 * 
	 * @param childNode 子ノード名
	 */
	public void setChildNode(String childNode) {
		this.childNode = childNode;
	}

	/**
	 * 参照オブジェクトのプロパティ名を取得します
	 * 
	 * @return 参照オブジェクトのプロパティ名
	 */
	public String getFromkey() {
		return fromkey;
	}

	/**
	 * 参照オブジェクトのプロパティ名を設定します
	 * 
	 * @param fromkey 参照オブジェクトのプロパティ名
	 */
	public void setFromkey(String fromkey) {
		this.fromkey = fromkey;
	}

	/**
	 * インデックス参照オブジェクト名を取得します
	 * 
	 * @return インデックス参照オブジェクト名
	 */
	public String getIdxRef() {
		return idxRef;
	}

	/**
	 * インデックス参照オブジェクト名を設定します
	 * 
	 * @param idxRef インデックス参照オブジェクト名
	 */
	public void setIdxRef(String idxRef) {
		this.idxRef = idxRef;
	}

	/**
	 * HTTP要求メッセージに生成するXML要素名を取得します
	 * 
	 * @return HTTP要求メッセージに生成するXML要素名
	 */
	public String getNode() {
		return node;
	}

	/**
	 * HTTP要求メッセージに生成するXML要素名を設定します
	 * 
	 * @param node HTTP要求メッセージに生成するXML要素名
	 */
	public void setNode(String node) {
		this.node = node;
	}

	/**
	 * 参照オブジェクト名を取得します
	 * 
	 * @return 参照オブジェクト名
	 */
	public String getObj() {
		return obj;
	}

	/**
	 * 参照オブジェクト名を設定します
	 * 
	 * @param obj 参照オブジェクト名
	 */
	public void setObj(String obj) {
		this.obj = obj;
	}

	/**
	 * データ取得メソッド名を取得します
	 * 
	 * @return データ取得メソッド名
	 */
	public String getTeleType() {
		return teleType;
	}

	/**
	 * データ取得メソッド名を設定します
	 * 
	 * @param teleType データ取得メソッド名
	 */
	public void setTeleType(String teleType) {
		this.teleType = teleType;
	}

	/**
	 * 空要素の送信有無を取得します
	 * 
	 * @return 空要素の送信有無
	 */
	public boolean isSendBlankElement() {
		return sendBlankElement;
	}

	/**
	 * 空要素の送信有無を設定します
	 * 
	 * @param sendBlankElement 空要素の送信有無
	 */
	public void setSendBlankElement(boolean sendBlankElement) {
		this.sendBlankElement = sendBlankElement;
	}

}
