/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * リモートイベントの送信先を定義するクラスです
 * HTTP要求のデフォルト送信先を定義します。
 */
public class RemoteUrl extends AbstractEventElement {

	/**
	 * デフォルトコンストラクタです
	 */
	public RemoteUrl() {
		super();
	}
	
	/**
	 * 通信リクエスト先のURL
	 * URLはコンテナHTMLからの相対パスとなります
	 */
	private String url;

	/**
	 * 通信リクエスト先のurlを取得します
	 * 
	 * @return 通信リクエスト先のurl
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * 通信リクエスト先のurlを設定します
	 * 
	 * @param url 通信リクエスト先のurl
	 */
	public void setUrl(String url) {
		this.url = url;
	}

}
