/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import jp.sf.maskat.core.layout.UnknownComponent;

import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;
import org.xml.sax.SAXException;

public class MaskatBeanReader extends BeanReader {
	
	public MaskatBeanReader() {
		super();
	}

	private boolean isText = false;
	private boolean isCdataSection = false;
	private String lastElementName = null;
	
    public void characters(char[] buffer, int start, int length) throws SAXException {
    	this.isCdataSection = (start == 0);
    	this.isText = !this.isCdataSection;
    	this.lastElementName = getCurrentElementName();
    	super.characters(buffer, start, length);
	}

  	public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
  		NamespacePrefixMapper mapper = getXMLIntrospector().getConfiguration().getPrefixMapper();
  		mapper.setPrefix(namespaceURI, prefix);
	}

	public void endElement(String namespaceURI, String localName,
            String qName) throws SAXException {
		Object object = this.stack.get();
		if (object instanceof UnknownComponent) {
			DynaProperty property =
				((UnknownComponent) object).getDynaClass().getDynaProperty("context");
			
			if (property instanceof jp.sf.maskat.core.layout.DynaProperty) {
				jp.sf.maskat.core.layout.DynaProperty p =
					(jp.sf.maskat.core.layout.DynaProperty) property;
				
				if (isTextOrCdataSection(object)) {
					p.setEnabled(true);
					p.setCdataSection(this.isCdataSection);
				} else {
					p.setEnabled(false);
				}
			}
		}
		super.endElement(namespaceURI, localName, qName);
		this.isText = false;
		this.isCdataSection = false;
	}
	
	private boolean isTextOrCdataSection(Object object) {
		if (this.lastElementName != null &&
				this.lastElementName.equals(getCurrentElementName())) {
			if (((UnknownComponent) object).getChildren().size() == 0) {
				return this.isText || this.isCdataSection;
			}
		}
		return false;
	}
}
