/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;


import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.DynaContainer;
import jp.sf.maskat.core.layout.UnknownComponent;
import jp.sf.maskat.core.layout.UnknownComponentClass;

import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.BeanCreationList;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;

/**
 * マスカットで使用するDynaBeanを生成するクラスです。
 * <p>
 * このクラスはbitwixtからモデル生成時に呼ばれるファクトリーチェーンです。
 * </p>
 */
/**
 * マスカットで使用するDynaBeanを生成するクラスです。
 * <p>
 * このクラスはbitwixtからモデル生成時に呼ばれるファクトリーチェーンです。
 * </p>
 */
public class DynaBeanCreationChain extends BeanCreationChain {

	/**
	 * {@inheritDoc}
	 */
	public Object create(ElementMapping elementMapping, ReadContext context) {
		Object bean = BeanCreationList.createDefaultChain().create(
				elementMapping, context);
		if (bean == null || bean instanceof DynaComponent) {
			try {
				Object dynaClass = ComponentRegistry
						.getComponentType(elementMapping.getNamespace(),
								elementMapping.getName());
				if (dynaClass == null) {
					/* unknown component */;
					String nameSpace = elementMapping.getNamespace();
					String prefix = null;
					if (nameSpace != null && nameSpace.trim().length() > 0) {
						ComponentLibrary lib = ComponentRegistry
								.getLibrary(nameSpace);
						if (lib != null) {
							prefix = lib.getPrefix();
						} else if (context != null) {
							NamespacePrefixMapper mapper = context.getXMLIntrospector()
									.getConfiguration().getPrefixMapper();
							prefix = mapper.getPrefix(nameSpace);
						}
					}
					bean = new UnknownComponent();
					dynaClass = new UnknownComponentClass(elementMapping
							.getName(), UnknownComponent.class, prefix,
							collectProperties(elementMapping));
					((UnknownComponent) bean)
							.setDynaClass((UnknownComponentClass) dynaClass);
				} else {
					/* customize component */
					if (((DynaComponentClass) dynaClass).isContainer()) {
						bean = new DynaContainer();
					}
					bean = (bean == null) ? new DynaComponent() : bean;
					((DynaComponent) bean)
							.setDynaClass((DynaComponentClass) dynaClass);
				}
				/*
				 * update the attributeDescriptors of this element
				 * populateAttributes here.
				 */
				context.pushBean(bean);
				context.populateAttributes(context.getXMLIntrospector()
						.introspect(bean).getElementDescriptor()
						.getAttributeDescriptors(), elementMapping
						.getAttributes());
				context.popBean();
			} catch (IntrospectionException e) {
				e.printStackTrace();
			}
		}
		return bean;
	}

	/**
	 * 指定されたマッピングに定義されている未知の属性名を配列で取得する
	 * 
	 * @param elementMapping 対象要素
	 * @return 属性名の配列
	 */
	private String[] collectProperties(ElementMapping elementMapping) {
		if (elementMapping == null || elementMapping.getAttributes() == null 
				|| elementMapping.getAttributes().getLength() == 0) {
			return new String[]{"context"};
		}
		List list = new ArrayList();
		int size = elementMapping.getAttributes().getLength();
		for (int i = 0; i < size; i++) {
			list.add(elementMapping.getAttributes().getQName(i));
		}
		list.add("context");
		return (String[]) list.toArray(new String[0]);
	}
}
