/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.figure;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class TabFigure extends Label {
	public static final int HEIGHT = 20;
	
	public TabFigure(String title) {
		setText(title);
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		setForegroundColor(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		setCursor(Cursors.HAND);
		setLayoutManager(new XYLayout());
	}
	
//	protected void paintFigure(Graphics graphics) {
//		super.paintFigure(graphics);
//		graphics.translate(bounds.x, bounds.y);
//		graphics.translate(-bounds.x, -bounds.y);
//	}
}
