/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.sf.maskat.core.MaskatElementVisitor;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.TreeViewEditPolicy;
import jp.sf.maskat.widget.rialto.figure.TreeViewFigure;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;



public class TreeViewEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	public IFigure createFigure() {
		Label label = new TreeViewFigure();
		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));

		label.setOpaque(false);
		XYLayout layout = new XYLayout();
		label.setLayoutManager(layout);
		return label;
	}

	protected List getModelChildren() {
		final List result = new ArrayList();
		DynaComponent def = (DynaComponent) getModel();
		DynaComponent treeNodeDef = (DynaComponent) def.getChildByTypeIdx(Component.class,0);

		// 一番目の子ノードのツリーノードしか子モデルとして扱う
		if (treeNodeDef != null) {
			result.add(treeNodeDef);
			treeNodeDef.accept(new MaskatElementVisitor() {
				public void visit(Object def) {
					result.add(def);
				}
			});
		}
		// ツリーに所属すべてのツリーノードを返す
		return result;
	}

	protected void createEditPolicies() {
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new TreeViewEditPolicy(style));
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName()) ||
			"removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
			forceRefresh();
		}
		super.propertyChange(evt);
	}

	protected void fireActivated() {
		super.fireActivated();
		forceRefresh();
	}

	protected void fireChildAdded(EditPart child, int index) {
		super.fireChildAdded(child, index);
		forceRefresh();
	}

	protected void refreshChildren() {
		super.refreshChildren();
		List children = getChildren();
		if (children.size() > 0) {
			TreeNodeEditPart child = (TreeNodeEditPart) children.get(0);
			child.setLayer(0);
			child.travel(0);
		}
	}

	public void forceRefresh() {
		refresh();
		// すべての子ノードをリフレッシュ
		for (Iterator it = this.getChildren().iterator(); it.hasNext();) {
			((EditPart) it.next()).refresh();
		}
	}
	
	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"treeNode".equals(child.getName())) {
				
				List children = getChildren();
				return children != null && children.size() == 0;
			}
		}
		return false;
	}

	public TreeNodeEditPart getModelToEditPart(Object model) {
		TreeNodeEditPart result = null;
		if (model instanceof DynaComponent) {
			List editParts = getChildren();
			for (int i = 0; i < editParts.size(); i++) {
				TreeNodeEditPart editPart = (TreeNodeEditPart) editParts.get(i);
				if (editPart.getModel() == model) {
					return editPart;
				}
			}
		}
		return result;
	}
}

