/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.widget.rialto.figure.TextFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;


public class TextEditPart extends ComponentEditPart
	implements LabelDirectEditable, HorizontalResizable {

	protected IFigure createFigure() {
		return new TextFigure(getLabel());
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				comp.getWidth(), d.height);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("initValue".equals(evt.getPropertyName())) {
			((TextFigure) getFigure()).setText((String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}
	
	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("initValue");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("initValue", text);
	}	
}
