/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.widget.rialto.RialtoPlugin;
import jp.sf.maskat.widget.rialto.figure.ComboFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;



public class ComboEditPart extends ComponentEditPart
	implements HorizontalResizable {

	public static final int MIN_HEIGHT_ITEM = 15;

	public void activate() {
		this.addEditPartListener(new EditPartListener.Stub() {
			public void selectedStateChanged(EditPart part) {
				if (part.getSelected() == SELECTED_PRIMARY) {
					setShowChildren(true);
				} else {
					setShowChildren(false);
				}
				refresh();
				super.selectedStateChanged(part);
			}
		});
		((Component) getModel()).addPropertyChangeListener(this);
		super.activate();
	}

	public boolean isShowChildren() {
		return ((ComboFigure) this.getFigure()).isChildrenShown();
	}

	public void setShowChildren(boolean showChildren) {
		((ComboFigure) this.getFigure()).setChildrenShown(showChildren);
		this.refresh();
		if (!showChildren) {
			((ComboFigure) this.getFigure()).setIcon(
					RialtoPlugin.getImage(RialtoPlugin.IMG_COMBOBOXDROPDOWN));
		} else {
			((ComboFigure) this.getFigure()).setIcon(null);
		}
	}

	protected IFigure createFigure() {
		return new ComboFigure();
	}

	protected List getModelChildren() {
		List result = ((Component) getModel()).getChildren();
		return (result == null) ? Collections.EMPTY_LIST : result; 
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
			|| "removeChild".equals(evt.getPropertyName())) {
			if (getParent() != null) {
				refresh();
			}
		}
		if (getParent() != null) {
//			refreshVisuals();
			super.propertyChange(evt);
		}
	}
	
	protected void refreshVisuals() {
		//Combo combo = (Combo) getModel();
		Component combo = (Component) getModel();
		int displayHeight = ComboFigure.DEFAULT_HEIGHT;
		if (isShowChildren()) {
			int heightItem = Math.max(getHeightItem(), MIN_HEIGHT_ITEM);
			List elements = combo.getTypedChildren(LayoutElement.class);
			int childCount = elements.size();
			displayHeight += heightItem * childCount;
			
			this.getFigure().setOpaque(true);
		} else {
			this.getFigure().setOpaque(false);
		}
		Rectangle constraint = new Rectangle(combo.getLeft(), combo.getTop(), 
				combo.getWidth(), displayHeight);

		GraphicalEditPart part = (GraphicalEditPart) getParent();
		if (part != null) {
			part.setLayoutConstraint(this, getFigure(), constraint);
		}
		// 子EditPartのリフレッシュ
		for (Iterator it = this.getChildren().iterator(); it.hasNext();) {
			((EditPart) it.next()).refresh();
		}
	}
	
	public int getHeightItem() {
		Integer height = (Integer) ((DynaComponent) getModel()).get("heightItem");
		return height.intValue();
	}
	
	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"comboItem".equals(child.getName())) {
				return true;
			}
		}
		return false;
	}
}
