/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.export;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class XMLSchemaSelectGroup extends EventManager {
	
    private Object root;
    
    private Object currentTreeSelection;
    
    private Object currentListSelection;
    
    private ITreeContentProvider treeContentProvider;

    private IStructuredContentProvider listContentProvider;

    private ILabelProvider treeLabelProvider;

    private ILabelProvider listLabelProvider;

    private TreeViewer treeViewer;

    private TableViewer listViewer;
    
    private Control okControl = null;
    
    public XMLSchemaSelectGroup(Composite parent, Object rootObject,
            ITreeContentProvider treeContentProvider,
            ILabelProvider treeLabelProvider,
            IStructuredContentProvider listContentProvider,
            ILabelProvider listLabelProvider, int style, int width, int height) {

        root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        createContents(parent, width, height, style);
    }

    public void setSelectionControl(Control c) {
    	okControl = c;
    	if (okControl != null) {
    		okControl.setEnabled(false);
       	}
    }
    
    protected void createContents(Composite parent, int width, int height,
            int style) {

        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        composite.setFont(parent.getFont());
        createTreeViewer(composite, width / 2, height);
        createListViewer(composite, width / 2, height);
        initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        listViewer = new TableViewer(parent, SWT.BORDER);
        GridData data = new GridData(GridData.FILL_BOTH);
        data.widthHint = width;
        data.heightHint = height;
        listViewer.getTable().setLayoutData(data);
        listViewer.getTable().setFont(parent.getFont());
        listViewer.setContentProvider(listContentProvider);
        listViewer.setLabelProvider(listLabelProvider);
        listViewer.addSelectionChangedListener(new ListViewerListener());
    }
    
    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, SWT.BORDER);
        GridData data = new GridData(GridData.FILL_BOTH);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData(data);
        tree.setFont(parent.getFont());

        treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider(treeContentProvider);
        treeViewer.setLabelProvider(treeLabelProvider);
        treeViewer.addSelectionChangedListener(new TreeViewerListener());
    }

    protected void initialize() {
        treeViewer.setInput(root);
    }
    
    public Object getSelectObject() {
    	return currentListSelection;
    }
    
    private class ListViewerListener implements ISelectionChangedListener {
    	public void selectionChanged(SelectionChangedEvent event) {
    		IStructuredSelection selection = (IStructuredSelection) event
        		.getSelection();
    		Object selectedElement = selection.getFirstElement();
    		if (selectedElement != null) {
    			if (okControl != null) {
    				currentListSelection = selectedElement;
    				okControl.setEnabled(true);
    			}
    		}
    	}
    }
    
    private class TreeViewerListener implements ISelectionChangedListener {
    	public void selectionChanged(SelectionChangedEvent event) {
    		IStructuredSelection selection = (IStructuredSelection) event
        		.getSelection();
    		Object selectedElement = selection.getFirstElement();
    		if (selectedElement == null) {
    			currentTreeSelection = null;
    			currentListSelection = null;
    			listViewer.setInput(currentTreeSelection);
    			return;
    		}
    		if (selectedElement != currentTreeSelection) {
    			listViewer.setInput(selectedElement);
    		}
    		currentTreeSelection = selectedElement;
    		currentListSelection = null;
    		if (okControl != null) {
    			okControl.setEnabled(false);
    		}
    	}
    }
}
