/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ResultTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class MessageToBeReceivedTreeNode extends AbstractTreeNode {
	private static final String MESSAGE_TOBE_RECEIVE =
		Messages.getString("messageToBeReceivedTreeNode.messageTobeReceived"); //$NON-NLS-1$		

	private static final String ADD_MESSAGE_CONTENT =
		Messages.getString("messageToBeReceivedTreeNode.addMessageContent"); //$NON-NLS-1$
	
	
	public MessageToBeReceivedTreeNode(Event event) {
		super(event);
	}

	protected void loadChildren() {
		if(shouldLoadChildren()) {
			ResultTreeNode child = new ResultTreeNode(((Event)maskatElement).getResult());
			addChild(child);
		}
	}

	private boolean shouldLoadChildren() {
		return (maskatElement != null)
				&& ((Event)maskatElement).getTypedChildren(Result.class) != null
				&& ((Event)maskatElement).getResult() != null
				&& ((Event)maskatElement).getResult().isEnable();
	}
	
	/**destroy the result bean of the child after remove the child*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		if (!hasLocalDataBinding()) {
			maskatElement.removeChild(child.getModel());
		} else {
			removeRemoteDataBinding();
		}
	}
	
	private boolean hasLocalDataBinding() {
		if (((Event)maskatElement).getTypedChildren(Result.class) == null) {
			return false;
		}
		Result result = ((Event)maskatElement).getResult();
		if (result != null) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				if ("local".equals(targets[i].getType())) {
					return true;
				}
			}
		}
		return false;
	}
	
	private void removeRemoteDataBinding() {
		Result result = ((Event)maskatElement).getResult();
		if (result == null) {
			return;
		}
		Target[] targets = result.getTargets();
		for (int i = 0; i < targets.length; i++) {
			if (!"local".equals(targets[i].getType())) {
				result.removeChild(targets[i]);
			}
		}
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);

		Result result = ((Event) maskatElement).getResult();
		if (result == null) {
			maskatElement.addChild(child.getModel());
		} else {
			Result temp = (Result) child.getModel();
			Target[] targets = temp.getTargets();
			for (int i = 0; i < targets.length; i++) {
				result.addChild(targets[i]);
			}
		}
		for (int i=0; i<child.getChildren().length; i++) {
			result.addChild(((ITreeNode)child.getChildren()[i]).getModel());
		}
		result.setEnable(true);
	}
	
	public boolean isDeletable() {
		return false;
	}

	public String getDisplayText() {
		return MESSAGE_TOBE_RECEIVE;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		if (getChildren().length == 0) {
			manager.add(new Action(ADD_MESSAGE_CONTENT){
				public void run() {
					Result result = ((Event)maskatElement).getResult();
					result.setEnable(true);
					ITreeNode childNode = new ResultTreeNode(result);
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
				}
			});
		}
		return manager;
	}
}
