/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * This is a <code>MessageDialog</code> which allows the user to choose an
 * option.
 */
public class OptionMessageDialog extends MessageDialog {

	public static final int OPTION1_SELECTED = 0;

	public static final int OPTION2_SELECTED = 1;

	public static final int CANCELED = -1;

	private Button option1;

	private Button option2;

	private Label desc1;

	private Label desc2;

	private String[] optionMessages;

	private String[] descriptionMessages;

	private int selected = CANCELED;

	/**
	 * Opens the dialog
	 * 
	 * @return 0 when the first option was selected, 1 when the second option
	 *         was selected, -1 when canceled or nothing was selected.
	 */
	public static int open(String id, Shell parent, String title,
			Image titleImage, String message, String[] optionMessages,
			String[] descriptionMessages, int dialogType,
			String[] buttonLabels, int defaultButtonIndex) {
		OptionMessageDialog dialog = new OptionMessageDialog(id, parent, title,
				titleImage, message, optionMessages, descriptionMessages,
				dialogType, buttonLabels, defaultButtonIndex);
		int ret = dialog.open();
		if (ret == 0) {
			return dialog.getSeletion();
		} else {
			return CANCELED;
		}
	}

	private OptionMessageDialog(String id, Shell parent, String title,
			Image titleImage, String message, String[] optionMessages,
			String[] descriptionMessages, int dialogType,
			String[] buttonLabels, int defaultButtonIndex) {
		super(parent, title, titleImage, message, dialogType, buttonLabels,
				defaultButtonIndex);
		this.optionMessages = optionMessages;
		this.descriptionMessages = descriptionMessages;
		if (this.optionMessages.length < 2) {
			this.optionMessages = new String[] { "", "" };
		}
		if (this.descriptionMessages.length < 2) {
			this.descriptionMessages = new String[] { "", "" };
		}
	}

	protected Control createCustomArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		option1 = new Button(composite, SWT.RADIO | SWT.LEFT);
		option1.setText(optionMessages[0]);
		desc1 = new Label(composite, SWT.NONE);
		desc1.setText(descriptionMessages[0]);
		option1.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				selected = OPTION1_SELECTED;
			}
		});
		option2 = new Button(composite, SWT.RADIO | SWT.LEFT);
		option2.setText(optionMessages[1]);
		desc2 = new Label(composite, SWT.NONE);
		desc2.setText(descriptionMessages[1]);
		option2.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				selected = OPTION2_SELECTED;
			}
		});
		applyDialogFont(option1);
		applyDialogFont(option2);
		applyDialogFont(desc1);
		applyDialogFont(desc2);
		return composite;
	}

	private int getSeletion() {
		return selected;
	}
}
