/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.ui.editors.layout.tools.DirectEditable;

import org.eclipse.gef.commands.Command;


public class TextDirectEditCommand extends Command {

	private DirectEditable  editable;
	private String oriText;
	private String text;

	public TextDirectEditCommand(DirectEditable edit, String text) {
		this.editable = edit;
		this.text = text;
	}

	public void execute() {
		oriText = editable.get();
		editable.set(text);
	}

	public void undo() {
		editable.set(oriText);
	}
}
