/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MaskatUIPlugin extends AbstractUIPlugin
	implements ISharedImages {

	/** The shared instance. */
	private static MaskatUIPlugin plugin;

	/** The plug-in ID */
	public static final String PLUGIN_ID = "jp.sf.maskat.ui"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * The constructor.
	 */
	public MaskatUIPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MaskatUIPlugin getDefault() {
		return plugin;
	}

	protected void initializeImageRegistry(ImageRegistry reg) {
		reg.put(IMG_COMPONENT_LAYOUT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/layout.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_TEXT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/text.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_CUSTOM, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/custom.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_UNKNOWN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/unknown_obj.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_JAVASCRIPT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/javascript.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_DESC, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/desc.gif")); //$NON-NLS-1$
		reg.put(IMG_COMPONENT_EVALUATOR, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/evaluator.gif")); //$NON-NLS-1$
		
		reg.put(IMG_COMPONENTICON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/componenticon.gif")); //$NON-NLS-1$

		reg.put(IMG_OBJ_ELEMENT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/obj16/element.gif")); //$NON-NLS-1$		

		reg.put(IMG_HORIZONTAL_ACTION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/th_horizontal.gif")); //$NON-NLS-1$
		reg.put(IMG_VERTICAL_ACTION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/th_vertical.gif")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWPROJECT, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newprj_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWAPPLICATION, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newapp_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_NEWFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/newfile_wiz.png")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_MASKATFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/maskatfile.gif")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_HTMLFILE, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/containerhtml.gif")); //$NON-NLS-1$
		reg.put(IMG_WIZBAN_PLUGIN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/plugin.gif")); //$NON-NLS-1$		
		reg.put(IMG_WIZBAN_REQUIRED_PLUGIN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/wizban/required_plugin.gif")); //$NON-NLS-1$		
	}

	public static ImageDescriptor getImageDescriptor(IConfigurationElement element,
			String attributeName) {
		String path = element.getAttribute(attributeName);
		if (path == null) {
			return null;
		}
		String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
		return AbstractUIPlugin.imageDescriptorFromPlugin(pluginId, path);
	}

	public static Image getImage(String key) {
		return getDefault().getImageRegistry().get(key);
	}

	public static ImageDescriptor getImageDescriptor(String key) {
		return getDefault().getImageRegistry().getDescriptor(key);
	}

	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}

}
