/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class MaskatRuntimePlugin extends AbstractUIPlugin {

	/** The plug-in ID */
	public static final String PLUGIN_ID = "jp.sf.maskat.runtime"; //$NON-NLS-1$

	/** Plug-in relative path for Maskat framework resources */
	public static final String RESOURCES_PATH = "/resources"; //$NON-NLS-1$

	/** The shared instance */
	private static MaskatRuntimePlugin plugin;

	/**
	 * The constructor
	 */
	public MaskatRuntimePlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static MaskatRuntimePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	/**
	 * Returns a local file URL for the root directory containing Maskat
	 * framework resources.
	 * 
	 * @return the local file URL or null
	 */
	public static URL getFrameworkBaseURL() {
		try {
			Bundle bundle = getDefault().getBundle();
			URL url = FileLocator.find(bundle, new Path(RESOURCES_PATH), null);
			return FileLocator.toFileURL(url);
		} catch (IOException e) {
			return null;
		}
	}
	
	/**
	 * Returns a local file URL for the root directory containing Maskat
	 * framework resources.
	 * 
	 * @return the local file URL or null
	 */
	public static URL[] getResourceURLs() {
		ArrayList list = new ArrayList();
		try {
			IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(
					PLUGIN_ID, "resources"); //$NON-NLS-1$
			IExtension[] extensions = point.getExtensions();
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] elements = extensions[i].getConfigurationElements();
				for (int j = 0; j < elements.length; j++) {
					IConfigurationElement element = elements[j];
					String path = element.getAttribute("path"); //$NON-NLS-1$
					if (path != null) {
						IContributor contributor = element.getContributor();
						list.add(FileLocator.toFileURL(
								Platform.getBundle(contributor.getName()).getEntry(path)));
					}
				}
			}		
		} catch (IOException e) {
			return null;
		}
		return (URL[]) list.toArray(new URL[0]);
	}	
}
