/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

public class Source extends AbstractEventElement {
	
	public static final boolean SEND_BLANK_ELEMENT_DEFAULT = false;
	
	public static final int MIN_DEFAULT = -1;
	
	public static final int MAX_DEFAULT = -1;
	
	public static final String FROM_KEY_DEFAULT = "";
	
	public static final String TYPE_DEFAULT = "disabled";

	private String obj;

	private String node;

	private String idxRef;

	private String childNode;

	private String fromkey = FROM_KEY_DEFAULT;

	private String type;

	private String desc;

	private int min = MIN_DEFAULT;

	private int max = MAX_DEFAULT;

	private String regexp;

	private String teleType;

	private boolean sendBlankElement = SEND_BLANK_ELEMENT_DEFAULT;

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	public String getRegexp() {
		return regexp;
	}

	public void setRegexp(String regexp) {
		this.regexp = regexp;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Bind[] getBinds() {
		return (Bind[]) getTypedChildren(Bind.class).toArray(new Bind[0]);
	}

	public String getChildNode() {
		return childNode;
	}

	public void setChildNode(String childNode) {
		this.childNode = childNode;
	}

	public String getFromkey() {
		return fromkey;
	}

	public void setFromkey(String fromkey) {
		this.fromkey = fromkey;
	}

	public String getIdxRef() {
		return idxRef;
	}

	public void setIdxRef(String idxRef) {
		this.idxRef = idxRef;
	}

	public String getNode() {
		return node;
	}

	public void setNode(String node) {
		this.node = node;
	}

	public String getObj() {
		return obj;
	}

	public void setObj(String obj) {
		this.obj = obj;
	}

	public String getTeleType() {
		return teleType;
	}

	public void setTeleType(String teleType) {
		this.teleType = teleType;
	}

	public boolean isSendBlankElement() {
		return sendBlankElement;
	}

	public void setSendBlankElement(boolean sendBlankElement) {
		this.sendBlankElement = sendBlankElement;
	}

}
